<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Address extends Model
{
    protected $fillable = [
        'user_id',
        'address',
        'address_one',
        'address_two',
        'city_id',
        'state_id',
        'country_id',
        'postal',
        'landmark',
        'latitude',
        'longitude',
        'is_default',
        'type',
    ];

    protected function casts()
    {
        return [
            'is_default' => 'boolean',
        ];
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function city()
    {
        return $this->belongsTo(City::class);
    }

    public function state()
    {
        return $this->belongsTo(State::class);
    }

    public function country()
    {
        return $this->belongsTo(Country::class);
    }

    public function getFullAddressAttribute()
    {
        return "{$this->address}, {$this->city->name}, {$this->state->name}, {$this->country->name}, {$this->postal}";
    }

    public function getFullAddressOneAttribute()
    {
        return "{$this->address_one}, {$this->city->name}, {$this->state->name}, {$this->country->name}, {$this->postal}";
    }

    public function getFullAddressTwoAttribute()
    {
        return "{$this->address_two}, {$this->city->name}, {$this->state->name}, {$this->country->name}, {$this->postal}";
    }
}
